import {
        fakeAsync,
        async,
        ComponentFixture,
        TestBed,
        getTestBed,
        tick
       } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing'
import { FormControl,
        FormGroup,
        Validators
       } from '@angular/forms';

import { ErrorService } from '../../core/error-messages/error.service'
import { FhirResourceComponent } from './fhir-resource.component'
import { FhirOrganizationComponent } from './organization/organization.component'
import { FhirPractitionerComponent } from './practitioner/practitioner.component'
import { FhirPatientComponent } from './patient/patient.component'
import { FhirConditionComponent } from './condition/condition.component'
import { FhirFindComponent } from './find/find.component'
import { Resource } from '../../mccf-data/fhir/resource'

describe('FhirResourceComponent', () => {
  let component: FhirResourceComponent
  let fixture: ComponentFixture<FhirResourceComponent>

  jasmine.DEFAULT_TIMEOUT_INTERVAL = 140000

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        FhirResourceComponent,
        FhirPractitionerComponent,
        FhirPatientComponent,
        FhirOrganizationComponent,
        FhirConditionComponent,
        FhirFindComponent
      ],
      providers: [ErrorService]
    }).compileComponents()

  }))

  beforeEach(()=>{
    fixture = getTestBed().createComponent(FhirResourceComponent)
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  });

  it('select page should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<FhirResourceComponent> = getTestBed()
                    .createComponent(FhirResourceComponent)
    let comp = fixt.componentInstance
    comp.ngOnInit()
    fixt.detectChanges()
    tick()
    //console.error(' @@@@@@@@@@@@@@@@@@@@ doc='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error,result) => {
      this.res = result
      if(error) {
        console.error(error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))


  it('notfound page should have no accessibility issues', ((done) => {
    component.isLoading = false
    component.page = 'notfound'
    fixture.detectChanges()

    //console.warn(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error('AXE-CORE ERROR:'+error)
    })
  }))

  it('resource page should have no accessibility issues', ((done) => {
    component.isLoading = false
    component.page = 'resource'
    component.resource = new Resource()
    fixture.detectChanges()

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error('AXE-CORE ERROR:'+error)
    })
  }))



  it('functions to work', () => {
    component.fhirUtilChange({srcElement: {value: 'test'}})
    fixture.detectChanges()
    expect(component.util).toEqual('test')
  })



})
